<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;

class CountryController extends Controller
{

    //country index
    public function index(Request $request){
        $countries = Country::all();

        if($request->wantsJson()){
            return response()->json([
                'status' => 'success',
                'message' => 'data loaded successfully',
                'data' => $countries
            ],200);
        } else{
            Session::put('page', 'country');
            return view('admin.country.index', compact('countries'))->with('no', 1);
        }
    }

    //show create country page
    public function create(){
        return view('admin.country.create');
    }

    //store country data
    public function store(Request $request){

        try {
            //validate the data
            $validator = Validator::make($request->all(), [
                'name' => 'nullable|string|max:255',
                'flag' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);

            if ($validator->fails()) {
                //redirect back with errors
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $flag = $request->file('flag');

            //store data to storage and database
            $flagName = '';

            if($request->hasFile('flag')){
                $flagName = $flag->getClientOriginalName() .'_'. time() . "." . $flag->getClientOriginalExtension();
                //move file to storage
                if(file_exists($flag)){
                    $flag->move(public_path('images/flag'), $flagName);
                }
            }

            //store to database
            $countryData = Country::create([
                'name' => $request->input('name'),
                'flag' => $flagName
            ]);

            return redirect('admin/country')->with('success', 'Country created successfully');

        } catch (\Throwable $th) {
            return redirect('admin/country')->with('error', 'Failed to create country : '.$th->getMessage());
        }
    }


    //edit country
    public function edit($id){
        $countryData = Country::FindOrFail($id);
        return view('admin.country.edit', compact('countryData'));
    }

    //update country
    public function update(Request $request, $id){

        $getCountry = Country::FindOrFail($id);

        try {
            //validate the data
            $validator = Validator::make($request->all(), [
                'name' => 'nullable|string|max:255',
                'flag' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);

            if ($validator->fails()) {
                //redirect back with errors
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $flag = $request->file('flag');


            //store data to storage and database
            $flagName = '';

            if($request->hasFile('flag')){

                //Remove Old File From Public Folder
                $oldFilePath = public_path('images/flag/' . $getCountry->flag);

                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                //store new file to storage and
                $flagName = $flag->getClientOriginalName() .'_'. time() . "." . $flag->getClientOriginalExtension();
                //move file to storage
                if(file_exists($flag)){
                    $flag->move(public_path('images/flag'), $flagName);
                }

                //push flag name to server
                $getCountry-> flag = $flagName;
            }

            $getCountry->name = $request->input('name');
            $getCountry->update();

            return redirect('admin/country')->with('success', 'Country created successfully');

        } catch (\Throwable $th) {
            return redirect('admin/country')->with('error', 'Failed to create country : '.$th->getMessage());
        }
    }


    //delete country
    public function destroy($id){

        $getData = Country::FindOrFail($id);

        try {
            //remove image from storage
            if (!empty($getData->flag)) {
                $flagOldPath = public_path('images/flag/' . $getData->flag);
                if (file_exists($flagOldPath)) {
                    unlink($flagOldPath);
                }
            }
            
            $getData->delete();

            //redirect to country index page
            return redirect()->back()->with('success', 'Country deleted successfully');
        } catch (\Throwable $th) {
            return redirect('admin/country')->with('error', 'Failed to Delete country : '.$th->getMessage());
        }
    }
}
