<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Navigation;
use Validator;
use Session;

class NavigationController extends Controller
{
    public function index()
    {
        session::put('page','navigation');
        $allNavigation = Navigation::all();
        return view('admin.navigation.index', compact('allNavigation'))->with('no', 1);
    }

    public function create()
    {
        return view('admin.navigation.create');
    }

    public function store(Request $request)
    {   
        $rules = [
            'name' => 'required|string|max:255',
            'image' => 'required',
            'url' => $request->input('type') == 'web_url' ? 'required_if:type,web_url' : '',
            'target' => $request->input('type') == 'web_url' ? 'required_if:type,web_url' : '',
            'html_tag' => $request->input('type') == 'html_tag' ? 'required_if:type,html_tag' : '',
        ];

        $customMessage = [
            'name.required' => 'Name is required.',
            'image.required' => 'Image is required.',
            'url.required_if' => 'URL is required',
            'target.required_if' => 'Target is required.',
            'html_tag.required_if' => 'Html tag is required.',
        ];

        $validator = Validator::make($request->all(), $rules, $customMessage);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $image                  = $request->file('image');
        $imageName              = rand(1,999).'.'.$image->getClientOriginalName();
        $timestamp              = now()->timestamp;
        $directory              = 'upload/navigation_images/';
        $imageUrl               = $directory . $timestamp . '_' . $imageName;
        $image->move($directory, $timestamp . '_' . $imageName);

        $navigation = new Navigation();
        $navigation->name = $request->name;
        $navigation->image = $imageUrl;
        $navigation->type = $request->type;
        $navigation->url = $request->url;
        $navigation->url_dark = $request->url_dark;
        $navigation->target = $request->target;
        $navigation->html_tag = $request->html_tag;
        $navigation->show_header = $request->show_header;
        $navigation->show_footer = $request->show_footer;
        $navigation->save();

        return redirect()->route('navigation.index')->with('success', 'Navigation created successfully');
    }

    public function edit($id)
    {
        $navigation = Navigation::findOrFail($id);

        return view('admin.navigation.edit', compact('navigation'));
    }

    public function update(Request $request, $id)
    {        
        $rules = [
            'name' => 'required|string|max:255',
            'url' => $request->input('type') == 'web_url' ? 'required_if:type,web_url' : '',
            'target' => $request->input('type') == 'web_url' ? 'required_if:type,web_url' : '',
            'html_tag' => $request->input('type') == 'html_tag' ? 'required_if:type,html_tag' : '',
        ];

        $customMessage = [
            'name.required' => 'Name is required.',
            'url.required_if' => 'URL is required',
            'target.required_if' => 'Target is required.',
            'html_tag.required_if' => 'Html tag is required.',
        ];

        $validator = Validator::make($request->all(), $rules, $customMessage);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

       $navigation = Navigation::find($id);
       $navigation->name = $request->name;

        if ($request->hasFile('image')) {
            if (!empty($navigation->image)) {
                unlink($navigation->image);
            }

            $image              = $request->file('image');
            $imageName          = rand(1,999).'.'.$image->getClientOriginalName();
            $timestamp          = now()->timestamp;
            $directory          = 'upload/navigation_images/';
            $imageUrl           = $directory . $timestamp . '_' . $imageName; 
            $image->move($directory, $timestamp . '_' . $imageName);
            $navigation->image = $imageUrl;
        }

        $navigation->type = $request->type;
        $navigation->url = $request->url;
        $navigation->url_dark = $request->url_dark;
        $navigation->target = $request->target;
        $navigation->html_tag = $request->html_tag;
        $navigation->show_header = $request->show_header;
        $navigation->show_footer = $request->show_footer;
        $navigation->save();
       
        return redirect()->route('navigation.index')->with('success', 'Navigation updated successfully');
    }

    
    public function destroy($id)
    {
        $navigation = Navigation::findOrFail($id);

        if (!empty($navigation->image)) {
            unlink($navigation->image);
        }
    
        $navigation->delete();

        return redirect()->route('navigation.index')->with('success', 'Navigation deleted successfully');
    }
}
