<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Radio;
use App\Category;
use App\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;

use GuzzleHttp\Client;

class RadioController extends Controller
{

    //get all radios
    public function index(Request $request){

        $allRadio = Radio::all();

        if($request->wantsJson()){
            return response()->json([
                'status' => 'success',
                'message' => 'data loaded successfully',
                'data' => $allRadio
            ],200);
        } else{
            Session::put('page', 'radio');
            return view('admin.radio.index', compact('allRadio'))->with('no', 1);
        }
    }

    //Create radio
    public function create(){
        $categories = Category::all();
        $countries = Country::all();
        return view('admin.radio.create', compact('categories', 'countries'));
    }


    //Store Radio Channel
    public function store(Request $request){
        try {
            //validate the data
            $validator = Validator::make($request->all(), [
                'category_id' => 'nullable|integer|max:255',
                'country_id' => 'nullable|integer|max:255',
                'channel_title' => 'nullable|string|max:255',
                'channel_url' => 'nullable|url',
                'channel_signal' => 'nullable|string|max:255',
                'cover' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
                'description' => 'nullable|string|max:5000',
            ]);

            if ($validator->fails()) {
                //redirect back with errors
                return redirect()->back()->withErrors($validator)->withInput();
            }

             //store data to storage and database
            $coverImage = $request->file('cover');
            $coverImageName = '';

            if($request->hasFile('cover')){
                $coverImageName = $coverImage->getClientOriginalName() .'_'. time() . "." . $coverImage->getClientOriginalExtension();
                //move file to storage
                if(file_exists($coverImage)){
                    $coverImage->move(public_path('images/radioCover'), $coverImageName);
                }
            }
        } catch (\Throwable $th) {
            return redirect('admin/radio')->with('error', 'Failed to store radio : '.$th->getMessage());
        }

        //store data to database
        $storeRadio = Radio::create([
            'category_id' => $request->input('category_id'),
            'country_id' => $request->input('country_id'),
            'channel_title' => $request->input('channel_title'),
            'channel_url' => $request->input('channel_url'),
            'channel_signal' => $request->input('channel_signal'),
            'cover' => $coverImageName,
            'description' => $request->input('description')
        ]);

        return redirect('admin/radio')->with('success', 'Radio Channel Created Successfully');
    }

    //Edit radio  channel
    public function edit($id){
        $channel = Radio::FindOrFail($id);
        $categories = Category::all();
        $countries = Country::all();

        return view('admin.radio.edit',compact('channel', 'categories', 'countries'));
    }


    //update radio channel
    public function update(Request $request, $id){

        try {

            $getRadioData = Radio::FindOrFail($id);
            //validate the data
            $validator = Validator::make($request->all(), [
                'category_id' => 'nullable|integer|max:255',
                'country_id' => 'nullable|integer|max:255',
                'channel_title' => 'nullable|string|max:255',
                'channel_url' => 'nullable|url',
                'channel_signal' => 'nullable|string|max:255',
                'cover' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
                'description' => 'nullable|string|max:5000',
            ]);

            if ($validator->fails()) {
                //redirect back with errors
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $coverImage = $request->file('cover');


            //store data to storage and database
            $coverImageName = '';

            if($request->hasFile('cover')){

                //Remove Old File From Public Folder
                $oldFilePath = public_path('images/radioCover/' . $getRadioData->cover);

                if (file_exists($oldFilePath)) {
                    unlink($oldFilePath);
                }

                //store new file to storage and
                $coverImageName = $coverImage->getClientOriginalName() .'_'. time() . "." . $coverImage->getClientOriginalExtension();
                //move file to storage
                if(file_exists($coverImage)){
                    $coverImage->move(public_path('images/radioCover'), $coverImageName);
                }

                //push flag name to server
                $getRadioData->cover = $coverImageName;
            }

            $getRadioData->category_id = $request->input('category_id');
            $getRadioData->country_id = $request->input('country_id');
            $getRadioData->channel_title = $request->input('channel_title');
            $getRadioData->channel_url = $request->input('channel_url');
            $getRadioData->channel_signal = $request->input('channel_signal');
            $getRadioData->description = $request->input('description');
            $getRadioData->update();

            return redirect('admin/radio')->with('success', 'Radio data updated successfully');

        } catch (\Throwable $th) {
            return redirect('admin/radio')->with('error', 'Failed to store radio : '.$th->getMessage());
        }
    }

    //delete radio channel
    public function destroy($id){
        try {
            $getRadio = Radio::FindOrFail($id);

            //remove image from storage
            if (!empty($getRadio->cover)) {
                $coverOldPath = public_path('images/radioCover/' . $getRadio->cover);
                if (file_exists($coverOldPath)) {
                    unlink($coverOldPath);
                }
            }

            $getRadio->delete();

            //redirect to country index page
            return redirect()->back()->with('success', 'Radio deleted successfully');

        } catch (\Throwable $th) {
            return redirect('admin/radio')->with('error', 'Failed to Delete Radio Channel : '.$th->getMessage());
        }
    }


    //get modified data
    public function getRadioMetadata(Request $request)
    {
        $streamUrl = 'http://clasicradio.ro:8008/stream';
        //$streamUrl = $request->input('stream_url');
        $client = new Client();
        $response = $client->get($streamUrl, ['stream' => true]);

        $headers = $response->getHeaders();

        $infoData = [
            'notice1' => $headers['icy-notice1'][0],
            'notice2' => $headers['icy-notice2'][0],
            'accept_ranges' => $headers['Accept-Ranges'][0],
            'access_control_allow_origin' => $headers['Access-Control-Allow-Origin'][0],
            'cache_control' => $headers['Cache-Control'][0],
            'url' => $headers['icy-url'][0],
            'connection' => $headers['Connection'][0],
            'channel_name' => $headers['icy-name'][0],
            'radio_genre' => $headers['icy-genre'][0],
            'pub' => $headers['icy-pub'][0],
            'bit_rate' => $headers['icy-br'][0],
            'stream_title' => $headers['icy-sr'][0],
            'x_clacks_overhead' => $headers['X-Clacks-Overhead'][0],
        ];

        if($headers !== null){
            return response()->json([
                'status' => 'success',
                'message' => 'Data loaded successfully',
                'data' => $infoData
            ]);
        }
        // $metadata = isset($headers['icy-notice2'][0]) ? (int)$headers['icy-notice2'][0] : null;

        // if ($metadata !== null) {
        //     $audioData = $response->getBody()->read($metadata);
        //     $metadataLength = ord($audioData[0]) * 16;

        //     if ($metadataLength > 0) {
        //         $metadataString = substr($audioData, 1, $metadataLength);
        //         parse_str($metadataString, $metadataArray);

        //         return response()->json($metadataArray);
        //     }
        // }


        return response()->json(['error' => 'No data available']);
    }
}
