<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;

class CountryController extends Controller
{

    //country index
    public function index(Request $request){
        $countries = Country::all();

        if($request->wantsJson()){
            return response()->json([
                'status' => 'success',
                'message' => 'data loaded successfully',
                'data' => $countries
            ],200);
        } else{
            Session::put('page', 'country');
            return view('admin.country.index', compact('countries'))->with('no', 1);
        }
    }


    //get Radio by country
    public function getRadioByCountry($id){

        $getCountry = Country::with('radio')->findOrFail($id);

        return response()->json([
            'status' => 'success',
            'message' => 'data loaded successfully',
            'data' => $getCountry
        ],200);

    }
}
