<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Navigation;
use Validator;

class NavigationController extends Controller
{
    public function getAllNavigation()
    {
        $allNavigation = Navigation::all();

        if ($allNavigation->isNotEmpty()) {
            return response()->json([
                'status' => 'success',
                'data' => $allNavigation,
            ], 200);
        } else {
            return response()->json([
                'status' => 'success',
                'message' => 'No navigation data found.',
                'data' => [],
            ], 200);
        }  
    }
}
