<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Radio;
use App\Category;
use App\Country;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;

use GuzzleHttp\Client;

class RadioController extends Controller
{

    //get all radios
    public function index(Request $request){

        $allRadio = Radio::all();

        if($request->wantsJson()){
            return response()->json([
                'status' => 'success',
                'message' => 'data loaded successfully',
                'data' => $allRadio
            ],200);
        } else{
            Session::put('page', 'radio');
            return view('admin.radio.index', compact('allRadio'))->with('no', 1);
        }
    }

    //Get radio by id with fetched data
    public function getRadioById($id){

        $getRadio = Radio::FindOrFail($id);
        try {
            $streamUrl = $getRadio->channel_url;
            //$streamUrl = $request->input('stream_url');
            $client = new Client();
            $response = $client->get($streamUrl, ['stream' => true]);

            $headers = $response->getHeaders();

            $channelData = [
                'notice1' => $headers['icy-notice1'][0],
                'notice2' => $headers['icy-notice2'][0],
                'accept_ranges' => $headers['Accept-Ranges'][0],
                'access_control_allow_origin' => $headers['Access-Control-Allow-Origin'][0],
                'cache_control' => $headers['Cache-Control'][0],
                'url' => $headers['icy-url'][0],
                'connection' => $headers['Connection'][0],
                'channel_name' => $headers['icy-name'][0],
                'radio_genre' => $headers['icy-genre'][0],
                'pub' => $headers['icy-pub'][0],
                'bit_rate' => $headers['icy-br'][0],
                'stream_title' => $headers['icy-sr'][0],
                'x_clacks_overhead' => $headers['X-Clacks-Overhead'][0],
                'others_data' => $getRadio
            ];

            if($headers !== null){
                return response()->json([
                    'status' => 'success',
                    'message' => 'Data loaded successfully',
                    'data' => $channelData
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                'message' => 'failed to load data : '.$th->getMessage(),
            ],500);
        }
    }


    //Search Radio channel query
    public function search(Request $request)
    {
        try {
            // Get the search query from the request
            $searchQuery = $request->input('search');

            // Query the Radio model with the search criteria
            $channels = Radio::where('channel_title', 'like', '%' . $searchQuery . '%')
                ->orWhere('description', 'like', '%' . $searchQuery . '%')
                ->orWhereHas('category', function ($query) use ($searchQuery) {
                    $query->where('category_name', 'like', '%' . $searchQuery . '%');
                })
                ->orWhereHas('country', function ($query) use ($searchQuery) {
                    $query->where('name', 'like', '%' . $searchQuery . '%');
                })
                ->get();

            return response()->json([
                'channels' => $channels
            ],200);

        } catch (\Throwable $th) {
            return response()->json([
                'status' => 'error',
                'message' => 'failed to load data : '.$th->getMessage(),
            ],500);
        }

    }
    //get modified data
    public function getRadioMetadata(Request $request)
    {
        $streamUrl = 'http://clasicradio.ro:8008/stream';
        //$streamUrl = $request->input('stream_url');
        $client = new Client();
        $response = $client->get($streamUrl, ['stream' => true]);

        $headers = $response->getHeaders();

        $infoData = [
            'notice1' => $headers['icy-notice1'][0],
            'notice2' => $headers['icy-notice2'][0],
            'accept_ranges' => $headers['Accept-Ranges'][0],
            'access_control_allow_origin' => $headers['Access-Control-Allow-Origin'][0],
            'cache_control' => $headers['Cache-Control'][0],
            'url' => $headers['icy-url'][0],
            'connection' => $headers['Connection'][0],
            'channel_name' => $headers['icy-name'][0],
            'radio_genre' => $headers['icy-genre'][0],
            'pub' => $headers['icy-pub'][0],
            'bit_rate' => $headers['icy-br'][0],
            'stream_title' => $headers['icy-sr'][0],
            'x_clacks_overhead' => $headers['X-Clacks-Overhead'][0],
        ];

        if($headers !== null){
            return response()->json([
                'status' => 'success',
                'message' => 'Data loaded successfully',
                'data' => $infoData
            ]);
        }
        // $metadata = isset($headers['icy-notice2'][0]) ? (int)$headers['icy-notice2'][0] : null;

        // if ($metadata !== null) {
        //     $audioData = $response->getBody()->read($metadata);
        //     $metadataLength = ord($audioData[0]) * 16;

        //     if ($metadataLength > 0) {
        //         $metadataString = substr($audioData, 1, $metadataLength);
        //         parse_str($metadataString, $metadataArray);

        //         return response()->json($metadataArray);
        //     }
        // }


        return response()->json(['error' => 'No data available']);
    }
}
