<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Settings;

class SettingsController extends Controller
{
    public function privacy_policy(){
       $privacy_policy = Settings::select('id','app_fcm_key','privacy_policy')->first();

       return response()->json($privacy_policy);
    }

    public function getSettingsInfo() {
        $generalSettingsInfo = Settings::all();

        if ($generalSettingsInfo->isNotEmpty()) {
            return response()->json([
                'status' => 'success',
                'data' => $generalSettingsInfo,
            ], 200);
        } else {
            return response()->json([
                'status' => 'success',
                'message' => 'No general settings data found.',
                'data' => [],
            ], 200);
        }  
    }

    public function update(Request $request)
    {
        $setting = Settings::first();

        
        $setting->update($request->all());
        return response()->json([
            'message'=>'Ads updated successfully!',
            'Status'=>200 
        ]);
    }
}
