<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->text('app_fcm_key');
            $table->integer('zoom_control')->nullable();
            $table->string('api_key')->nullable();
            $table->string('app_version')->nullable();
            $table->string('about_us_url')->nullable();
            $table->string('privacy_policy_url')->nullable();
            $table->string('terms_and_condition_url')->nullable();
            $table->string('rate_us_url')->nullable();
            $table->string('custom_user_agent')->nullable();
            $table->text('privacy_policy')->nullable();
            $table->text('one_signal')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
