@extends('layouts.admin_layout.admin_layout')
@section('content')

<style>
    .admin {
        background-color: #21272D;
    }
    .admin:hover {
        background-color: #4C4A3B;
    }

    .navigation {
        background-color: #21272D;
    }
    .navigation:hover {
        background-color: #314055;
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper custom-content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Dashboard</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}" style="color: #87888C">Home</a></li>
                        <li class="breadcrumb-item">Dashboard</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-6 col-lg-3">
                    <a href="{{ url('admin/navigation') }}">
                        <div class="info-box navigation" style="display: flex; justify-content: center; align-items: center; padding: 22px;">
                            <div style="background-color: #314055; width: 70px; height: 70px; border-radius: 50%; display: flex; align-items: center; justify-content: center; z-index: 1;">
                                <img src="{{ asset('icons/navigation.png') }}" style="color: #5B93FF; height: 26px; width: 26px; z-index: 2;" alt="">
                            </div>
                            <div class="info-box-content ps-3">
                                <span class="info-box-text" style="color: #FFFFFF; font-size: 30px; font-weight: bold">{{$totalNavigation}}+</span>
                                <span class="" style="color: #87888C; margin: 0px">Navigation</span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-6 col-lg-3">
                    <a href="{{ url('admin/Aindex') }}">
                        <div class="info-box admin" style="display: flex; justify-content: center; align-items: center; padding: 22px;">
                            <div style="background-color: #4C4A3B; width: 70px; height: 70px; border-radius: 50%; display: flex; align-items: center; justify-content: center; z-index: 1;">
                                <img src="{{ asset('icons/admin.png') }}" style="color: #5B93FF; height: 26px; width: 26px; z-index: 2;" alt="">
                            </div>
                            <div class="info-box-content ps-3">
                                <span class="info-box-text" style="color: #FFFFFF; font-size: 30px; font-weight: bold">{{$totalAdmins}}+</span>
                                <span class="" style="color: #87888C; margin: 0px">Total Admins</span>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection