@extends('layouts.admin_layout.admin_layout')
@section('content')

<style>
    .note-editor.note-frame .note-editing-area .note-editable
    {
        background-color: #21272D !important;
        color: #CBD5DE; 
        border: 1px solid #858F98;
    }
    .note-popover .popover-content, .card-header.note-toolbar, 
    {
        background-color: #21272D !important;
        color: #CBD5DE; 
        border: 1px solid #858F98;
    }
    .note-editor.note-frame .note-statusbar .note-resizebar {
        background-color: #21272D !important;
    }
    .note-popover .popover-content, .card-header.note-toolbar {
        background-color: #21272D !important;
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper custom-content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Settings</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}" style="color: #87888C">Home</a></li>
                        <li class="breadcrumb-item">Settings</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <x-alert/>
            <div class="row">
                <div class="col-md-12">
                    <div class="card custom-card card-default">
                        <div class="card-header">
                            <h3 class="card-title">Settings</h3>
                        </div>
                        <form name="storyForm" id="storyForm" action="{{ url('admin/settings/update') }}" method="post" enctype="multipart/form-data">@csrf 
                            <div class="card-body">
                                <div class="form-group">
                                    <div class="form-line">
                                        <label class="font-12">FCM Server Key</label>
                                        <input type="text" class="form-control custom-input" name="app_fcm_key" id="app_fcm_key" value="{{$settings->app_fcm_key}}" required></input>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="zoom_control">Zoom Controls</label>
                                    <select name="zoom_control" id="zoom_control" class="form-control custom-input">
                                        <option value="1" @if($settings->zoom_control == 1) selected @endif>Yes</option>
                                        <option value="0" @if($settings->zoom_control == 0) selected @endif>No</option>                                    
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label class="font-12">More Apps Url</label>
                                </div>
                                <div class="form-group">
                                    <label for="about_us_url">About Us Url</label>
                                    <input type="text" class="form-control custom-input" id="about_us_url" name="about_us_url" value="{{$settings->about_us_url}}" placeholder="About Us Url">
                                </div>
                                <div class="form-group">
                                    <label for="privacy_policy_url">Privacy Policy Url</label>
                                    <input type="text" class="form-control custom-input" id="privacy_policy_url" name="privacy_policy_url" value="{{$settings->privacy_policy_url}}" placeholder="Privacy Policy Url">
                                </div>
                                <div class="form-group">
                                    <label for="terms_and_condition_url">Terms & Conditions Url</label>
                                    <input type="text" class="form-control custom-input" id="terms_and_condition_url" name="terms_and_condition_url" value="{{$settings->terms_and_condition_url}}" placeholder="Terms & Conditions Url">
                                </div>
                                <div class="form-group">
                                    <label for="about_us_url">Rate Us Url</label>
                                    <input type="text" class="form-control custom-input" id="rate_us_url" name="rate_us_url" value="{{$settings->rate_us_url}}" placeholder="Rate Us Url">
                                </div>
                                <div class="form-group">
                                    <label class="font-12">More Apps, User Agent and Privacy Policy</label>
                                </div>
                                <div class="form-group">
                                    <label for="custom_user_agent">Custom User Agent</label>
                                    <input type="text" class="form-control custom-input" id="custom_user_agent" name="custom_user_agent" value="{{$settings->custom_user_agent}}" placeholder="Enter Custom User Agent">
                                </div>
                                <div class="form-group">
                                    <div class="form-line">
                                        <label class="font-12">Privacy Policy</label>
                                        <textarea class="textarea" placeholder="Place some text here" name="privacy_policy" id="privacy_policy" required
                                            style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">
                                            {{$settings->privacy_policy}}
                                        </textarea>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit"  class="custom-submit">Update</button>
                                </div>
                             </div>
                        </form>

                        <div class="modal fade" id="modal-default">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title">Default Modal</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <input type="text" id="generateBox" class="form-control" placeholder="Enter ..." value="" name="">
                                    </div>
                                    <div class="modal-footer justify-content-between">
                                        <button type="button" onclick="generateToken()" class="btn btn-info">Generate Token</button>
                                        <button type="button" onclick="copyToken()" class="btn btn-primary">Apply Token</button>
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        are you sure you want to apply token?
                                        <p class="text-warning"> warning: you have to change your token in mobile devices also</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" onclick="applyToken()" class="btn btn-primary">yes</button>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
            </div>    
        </div>     
    </section>   
</div>
<!-- /.content-wrapper -->


<script type="text/javascript">
    function generateToken() {

         var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

         var length = 12
         var result = ' ';
         var charactersLength = characters.length;
         for (let i = 0; i < length; i++) {
             result += characters.charAt(Math.floor(Math.random() * charactersLength));
         }

         document.getElementById("generateBox").value = result;

     }

     function copyToken() {


         $('#modal-default').modal('hide');
         $('#exampleModal').modal('show');
     }

     function applyToken() {
         var generateBox = document.getElementById("generateBox")
         var tokenBox = document.getElementById("tokenBox")
         var result = generateBox.value;

         document.getElementById("tokenBox").value = generateBox.value;
         generateBox.value = ""
         $('#exampleModal').modal('hide');
}
</script>
  @endsection


            