@extends('layouts.admin_layout.admin_layout')
@section('content')

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Country</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}">Home</a></li>
              <li class="breadcrumb-item active">Country</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row justify-content-center">
        <div class="col-md-11">
          <x-alert/>
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">All Countries</h3>

                <a href="{{ url('admin/country/create') }}" style="max-width: 150px; float:right; display:inline-block;"
                class="btn btn-block btn-primary"><i class="fas fa-plus"></i>Add Country</a>
            </div>
            <!-- /.card-header -->
            <div class="card-body">

              <table id="category" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>Sl.No</th>
                  <th>Country Name</th>
                  <th>Flag</th>
                  <th>Actions</th>

                </tr>
                </thead>
                <tbody>
                @foreach($countries as $country)
                <tr>

                  <td>{{ $no++ }}</td>
                  <td>{{ucfirst($country->name)}}</td>
                  <td>

                  @if(!empty($country->flag))
                    <img style="width: 60px; height: 48px; border-radius:4px;" class="img-thumbnail" src="{{asset('images/flag/'.$country->flag)}}"/>
                  @endif
                  </td>
                  <td>
                    <a href="{{ url('admin/country/edit/'.$country->id) }}" class="btn btn-success" role="button"><i class="material-icons option-icon">mode_edit</i></a>
                    &nbsp; &nbsp;
                    <form action="{{ route('admin.country.destroy', $country->id ) }}" method="POST" style="display: inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" onclick="return confirm('Are you sure you want to delete this Country?')" class="btn btn-danger custom-btn" role="button"><i class="material-icons option-icon custom-icon">delete</i></button>
                    </form>
                  </td>

                </tr>
                @endforeach

                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  <!-- /.content-wrapper -->
  @endsection
