@extends('layouts.admin_layout.admin_layout')
@section('content')
<style>
    .ck-editor__editable {
        background-color: #21272D !important; 
        color: #CBD5DE !important; 
        border: 1px solid #858F98 !important;
        height: 200px !important;
    }
</style>
<div class="content-wrapper custom-content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Add Navigation</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}" style="color: #87888C">Home</a></li>
                        <li class="breadcrumb-item">Add Navigation</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card custom-card card-primary">
                        <br>
                        <x-alert />
                        <form name="navigationForm" id="navigationForm" action="{{ url('admin/navigation') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="name">Name</label>
                                    <input type="text" class="form-control custom-input" id="name" name="name" value="{{ old('name') }}" placeholder="Enter Name">
                                </div>
                                <div class="form-group">
                                    <label for="image">Image</label>
                                    <input type="file" class="form-control custom-input" id="image" name="image">
                                </div>
                                <div class="form-group">
                                    <label for="selection">Type</label>
                                    <select id="type" name="type" class="form-control custom-input">
                                        <option value="web_url">Web URL</option>
                                        <option value="html_tag">HTML Tag</option>
                                    </select>
                                </div>
                               <div id="webUrlFields" style="display: none;">
                                    <div class="form-group">
                                        <label for="url">URL</label>
                                        <input type="text" id="url" class="form-control custom-input" name="url" value="{{ old('url') }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="url_dark">URL Dark (Optional)</label>
                                        <input type="text" id="url_dark" class="form-control custom-input" name="url_dark" value="{{ old('url_dark') }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="target">Target</label>
                                        <select name="target" id="target" class="form-control custom-input">
                                            <option value="Internal">Internal</option>
                                            <option value="External">External</option>                                    
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group" id="htmlTagFields" style="display: none;">
                                    <label for="html_tag">Html Tag</label>
                                    <textarea id="editor" name="html_tag"  class="form-control custom-input"></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="show_header">Show Header?</label>
                                    <select name="show_header" id="show_header" class="form-control custom-input">
                                        <option value="0">Yes</option>
                                        <option value="1" selected>No</option>                                    
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="show_footer">Show Footer?</label>
                                    <select name="show_footer" id="show_footer" class="form-control custom-input">
                                        <option value="0">Yes</option>
                                        <option value="1" selected>No</option>                                    
                                    </select>
                                </div>
                            </div>
                            <div class="card-body">
                                <button type="submit" class="custom-submit">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<script>
    document.getElementById('type').addEventListener('change', function () {
        var webUrlFields = document.getElementById('webUrlFields');
        var htmlTagFields = document.getElementById('htmlTagFields');

        if (this.value === 'web_url') {
            webUrlFields.style.display = 'block';
            htmlTagFields.style.display = 'none';
        } else if (this.value === 'html_tag') {
            webUrlFields.style.display = 'none';
            htmlTagFields.style.display = 'block';
        } else {
            webUrlFields.style.display = 'none';
            htmlTagFields.style.display = 'none';
        }
    });

    // Initially show the webUrlFields since "Web URL" is selected by default
    document.getElementById('webUrlFields').style.display = 'block';
</script>
<script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
<script>
	ClassicEditor
		.create( document.querySelector( '#editor' ) ,
        {
            toolbar: ['heading', '|', 'bold', 'italic', 'link', 'bulletedList', 'numberedList', 'blockQuote'],
            autoGrow: true,
            autoGrow_minHeight: 300, // Set the minimum height
            autoGrow_bottomSpace: 10 // Set the bottom space
        })
		.catch( error => {
			console.error( error );
		} );
</script>
@endsection
