@extends('layouts.admin_layout.admin_layout')
@section('content')
<style>
    .ck-editor__editable {
        background-color: #21272D !important; 
        color: #CBD5DE !important; 
        border: 1px solid #858F98 !important;
        height: 200px !important;
    }
</style>
<div class="content-wrapper custom-content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Navigation</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}" style="color: #87888C">Home</a></li>
                        <li class="breadcrumb-item">Edit Navigation</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card custom-card card-primary">
                        <br>
                        <x-alert />
                        <form name="navigationForm" id="navigationForm" action="{{ url('admin/navigation/update', ['id' => $navigation->id]) }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="name">Name</label>
                                    <input type="text" class="form-control custom-input" id="name" value="{{ $navigation->name}}" name="name" value="{{ old('name') }}" placeholder="Enter Name">
                                </div>
                                <div class="form-group">
                                    <label for="image">Image</label>
                                    <input type="file" class="form-control custom-input" id="image" name="image">
                                    <img src="{{asset($navigation->image)}}" alt="Logo" style="height: 70px;" class="py-2">
                                </div>
                                <div class="form-group">
                                    <label for="selection">Type</label>
                                    <select id="type" name="type" class="form-control custom-input">
                                        <option value="web_url"  @if($navigation->type == 'web_url') selected @endif>Web URL</option>
                                        <option value="html_tag"  @if($navigation->type == 'html_tag') selected @endif>HTML Tag</option>
                                    </select>
                                </div>
                               <div id="webUrlFields"  @if($navigation->type != 'web_url') style="display: none;" @endif>
                                    <div class="form-group">
                                        <label for="url">URL</label>
                                        <input type="text" id="url" class="form-control custom-input" value="{{ $navigation->url}}" name="url" value="{{ old('url') }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="url_dark">URL Dark (Optional)</label>
                                        <input type="text" id="url_dark" class="form-control custom-input" value="{{ $navigation->url_dark}}" name="url_dark" value="{{ old('url_dark') }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="target">Target</label>
                                        <select name="target" id="target" class="form-control custom-input">
                                            <option value="Internal" @if($navigation->target == 'Internal') selected @endif>Internal</option>
                                            <option value="External" @if($navigation->target == 'External') selected @endif>External</option>                                    
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group" id="htmlTagFields" @if($navigation->type != 'html_tag') style="display: none;" @endif>
                                    <label for="html_tag">Html Tag</label>
                                    <textarea id="editor" name="html_tag"  class="form-control custom-input">{{ $navigation->html_tag}}</textarea>
                                </div>
                                <div class="form-group">
                                    <label for="show_header">Show Header?</label>
                                    <select name="show_header" id="show_header" class="form-control custom-input">
                                        <option value="0" @if($navigation->show_header == '0') selected @endif>Yes</option>
                                        <option value="1" @if($navigation->show_header == '1') selected @endif>No</option>                                    
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="show_footer">Show Footer?</label>
                                    <select name="show_footer" id="show_footer" class="form-control custom-input">
                                        <option value="0" @if($navigation->show_footer == '0') selected @endif>Yes</option>
                                        <option value="1" @if($navigation->show_footer == '1') selected @endif>No</option>                                    
                                    </select>
                                </div>
                            </div>
                            <div class="card-body">
                                <button type="submit" class="custom-submit">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
    document.getElementById('type').addEventListener('change', function () {
        var webUrlFields = document.getElementById('webUrlFields');
        var htmlTagFields = document.getElementById('htmlTagFields');

        if (this.value === 'web_url') {
            webUrlFields.style.display = 'block';
            htmlTagFields.style.display = 'none';
        } else if (this.value === 'html_tag') {
            webUrlFields.style.display = 'none';
            htmlTagFields.style.display = 'block';
        } else {
            webUrlFields.style.display = 'none';
            htmlTagFields.style.display = 'none';
        }
    });

    // Initially show the fields based on the selected type
    var initialType = document.getElementById('type').value;
    var webUrlFields = document.getElementById('webUrlFields');
    var htmlTagFields = document.getElementById('htmlTagFields');

    if (initialType === 'web_url') {
        webUrlFields.style.display = 'block';
        htmlTagFields.style.display = 'none';
    } else if (initialType === 'html_tag') {
        webUrlFields.style.display = 'none';
        htmlTagFields.style.display = 'block';
    } else {
        webUrlFields.style.display = 'none';
        htmlTagFields.style.display = 'none';
    }
</script>
<script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
<script>
	ClassicEditor
		.create( document.querySelector( '#editor' ) ,
        {
            toolbar: ['heading', '|', 'bold', 'italic', 'link', 'bulletedList', 'numberedList', 'blockQuote'],
        })
		.catch( error => {
			console.error( error );
		} );
</script>
@endsection
