@extends('layouts.admin_layout.admin_layout')
@section('content')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper custom-content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Navigation</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}" style="color: #87888C">Home</a></li>
                        <li class="breadcrumb-item">Navigation</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content text-white">
        <div class="row">
            <div class="col-md-12">
                <x-alert />
                <div class="card custom-card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-12 d-flex align-items-center">
                                <h3 class="card-title col-sm-6">Navigation</h3>
                                <div class="col-sm-6 text-right">
                                  <a href="{{ url('admin/navigation/create') }}" class="btn btn-success" style="background-color: #D3DB8C; color: black; font-weight: bold; border: none;"><strong style="font-size: 20px;">+</strong> Add</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                      <!-- <p class="text-success text-center">{{session('success')}}</p> -->
                        <div class="table-responsive">
                            <table id="story" class="table table-bordered" style="border: 1px solid #42484D">
                                <thead style="border: 1px solid #42484D">
                                    <tr style="height: 20px; max-height: 40px; border: 1px solid #42484D;">
                                        <th style="width: 70px; border: 1px solid #42484D;" class="table-row">SI</th>
                                        <th style="border: 1px solid #42484D;" class="table-row">Image</th>
                                        <th style="border: 1px solid #42484D;" class="table-row">Title</th>
                                        <th style="border: 1px solid #42484D;" class="table-row">Type</th>
                                        <th class="table-row" style="border: 1px solid #42484D">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($allNavigation as $navigation)
                                        <tr style="height: 30px; max-height: 40px;">
                                            <td class="table-row">{{ $no++ }}</td>
                                            <td class="table-row">
                                              <img src="{{asset($navigation->image)}}" alt="Logo" style="height: 70px; width: 110px;">
                                            </td>
                                            <td class="table-row">{{ $navigation->name }}</td>
                                            <td class="table-row">
                                                @if($navigation->type == 'web_url')
                                                    <span class="badge badge-success p-2">Web URL</span>
                                                @elseif($navigation->type == 'html_tag')
                                                    <span class="badge badge-success p-2">HTML Tag</span>
                                                @endif  
                                            </td>
                                            <td class="pl-4 table-row">
                                              <a href="{{ url('admin/navigation/edit/' . $navigation->id) }}" class="btn btn-sm btn-primary mr-1"  style="background-color: #7CA8FF; color: white; border: none;">Edit</a>
                                              <form action="{{ route('navigation.destroy', ['id' => $navigation->id])}}" method="post" class="d-inline">
                                                  @csrf
                                                  @method('DELETE')
                                                  <button type="submit" class="btn btn-sm btn-danger" style="background-color: #EC4A5E; color: white; border: none;" onclick="return confirm('Are you sure you want to delete this navigation?')">Delete</button>
                                              </form>
                                            </td>   
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
