@extends('layouts.admin_layout.admin_layout')
@section('content')
<div class="content-wrapper custom-content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Notifications</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ url('admin/dashboard') }}" style="color: #87888C">Home</a></li>
                        <li class="breadcrumb-item">Notifications</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card custom-card card-primary">
                        <br>
                        <x-alert />
                        <form name="notificationForm" id="notificationForm" action="{{ url('admin/notifications/send')}}" method="post" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="title">Title</label>
                                    <input type="text" class="form-control custom-input" id="title" placeholder="Title" name="title"></input>
                                </div>
                                <div class="form-group">
                                    <label for="formGroupExampleInput1">Message</label>
                                    <textarea type="text" class="form-control custom-input" id="formGroupExampleInput1" placeholder="message" name="message"></textarea>
                                </div>

                                <div class="form-group">
                                    <label for="url">Url</label>
                                    <input type="text" class="form-control custom-input" id="url" placeholder="https://www.google.com/" name="url"></input>
                                </div>

                                <div class="form-group">
                                    <label for="imageURl">Image Url</label>
                                    <input type="text" class="form-control custom-input" id="imageURl" placeholder=" https://xxxxxxxx.jpg/png/" name="image_url"></input>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="custom-submit">Send Notification</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

    
