@extends('layouts.admin_layout.admin_layout')
@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Channel</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ url('admin/video-index') }}">Manage Channel</a></li>
                        <li class="breadcrumb-item active">Add Channel</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>


    <section class="content">
        <div class="container-fluid">
            <x-alert />
            <div class="card card-default">
                <div class="card-header">
                    <h3 class="card-title">Add Channel</h3>
                </div>

                <form name="videoForm" id="videoForm" action="{{ url('admin/radio/'.$channel->id) }}" method="post"
                    enctype="multipart/form-data">@csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 col-sm-6">
                                <div class="form-group">
                                    <label for="Channel_title">Channel Name</label>
                                    <input type="text" class="form-control" name="channel_title" id="channel_title"
                                        value="{{ $channel->channel_title }}" placeholder="Enter Channel Title Here">
                                </div>
                            </div>
                            <!-- -->
                            <div class="col-12 col-sm-6">
                                <div class="form-group">
                                    <label>Category</label>
                                    <select name="category_id" id="category_id" class="form-control select2" style="width: 100%;">
                                        <option disabled value>Select Category</option>
                                        @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ $category->id == $channel->category_id ? 'selected' : '' }}>
                                            {{ $category->category_name }}
                                        </option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>

                            <!--  -->
                            <div class="col-12 col-sm-6">
                                <div class="form-group">
                                    <label>Country</label>
                                    <select name="country_id" id="country_id" class="form-control select2" style="width: 100%;">
                                        <option disabled value>Select Country</option>
                                        @foreach($countries as $country)
                                        <option value="{{ $country->id }}" {{ $country->id == $channel->country_id ? 'selected' : '' }}>
                                            {{ $country->name }}
                                        </option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>
                            <!--  -->
                            <div class="col-12 col-sm-6">
                                <div class="form-group" id="cover">
                                    <label for="radio_cover">Cover</label>
                                    <div class="input-group">
                                        <div class="input-group">
                                            <input type="file" class="form-control" id="radio_cover"
                                                name="cover">
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <br>
                                <div>
                                    <img  class="img-fluid img-thumbnail" alt="Responsive image"
                                            src="{{asset('images/radioCover/'.$channel->cover)}}">
                                </div>
                            </div>
                            <!--  -->
                            <div class="col-12 col-sm-6">
                                <div class="form-group" id="url">
                                    <label for="channel_url">Radio Url</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="channel_url" name="channel_url"
                                            value="{{ $channel -> channel_url }}"
                                            placeholder=" http://clasicradio.ro:8008/stream ">
                                    </div>
                                </div>

                            </div>
                            <!--  -->
                            <div class="col-12 col-sm-6">
                                <div class="form-group" id="url">
                                    <label for="channel_url">Channel Signal</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="channel_signal" name="channel_signal"
                                            value="{{ $channel->channel_signal }}"
                                            placeholder=" 99.9 Fm">
                                    </div>
                                </div>

                            </div>
                            <!--  -->

                        </div>
                        <br>

                        <div class="form-group">
                            <label for="description">
                                Description
                            </label>
                            <textarea class="textarea" placeholder="Place channel description text here" name="description"
                                required
                                style="width: 100%; height: 300px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">
                                {{ $channel -> description}}
                            </textarea>
                        </div>
                        <!-- /.description -->
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
</div>
@endsection

