<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\RadioController;
use App\Http\Controllers\Admin\NavigationController;


Route::get('/', function () {
    return view('welcome');
});

Auth::routes();


Route::prefix('/admin')->namespace('Admin')->group(function(){
    //All the admin route will be define here:-

    Route::match(['get','post'],'/','AdminController@login' );

    Route::group(['middleware'=>['admin']],function(){

        Route::get('dashboard','AdminController@dashboard');
        Route::get('logout','AdminController@logout');


        //Category Route
        Route::get('category_index','CategoryController@index');
        Route::get('category_create', 'CategoryController@create');
        Route::post('category_submit', 'CategoryController@store');
        Route::get('category_edit/{id}', 'CategoryController@edit');
        Route::post('category_update/{id}', 'CategoryController@update');
        Route::get('category_delete/{id}', 'CategoryController@destroy');

        //Navigation Route
        Route::get('navigation','NavigationController@index')->name('navigation.index');
        Route::get('navigation/create', 'NavigationController@create')->name('navigation.create');
        Route::post('navigation', 'NavigationController@store')->name('navigation.store');
        Route::get('navigation/edit/{id}', 'NavigationController@edit')->name('navigation.edit');
        Route::post('navigation/update/{id}', 'NavigationController@update')->name('navigation.update');
        Route::delete('navigation/destroy/{id}', 'NavigationController@destroy')->name('navigation.destroy');

        //Country routes
        Route::get('country', 'CountryController@index');
        Route::get('country/create', 'CountryController@create');
        Route::post('country', 'CountryController@store');
        Route::get('country/edit/{id}', 'CountryController@edit');
        Route::post('country/{id}', 'CountryController@update');
        Route::delete('country/{id}', 'CountryController@destroy')->name('admin.country.destroy');

        //Radio routes
        Route::get('radio', 'RadioController@index');
        Route::get('radio/create', 'RadioController@create');
        Route::post('radio', 'RadioController@store');
        Route::get('radio/edit/{id}', 'RadioController@edit');
        Route::post('radio/{id}', 'RadioController@update');
        Route::delete('radio/{id}', 'RadioController@destroy')->name('admin.radio.destroy');
        Route::get('radio/meta_data', 'RadioController@getRadioMetadata');


        //Item Route
        Route::get('item_index', 'ItemController@index');
        Route::get('item_create', 'ItemController@create');
        Route::post('item_submit', 'ItemController@store');
        Route::get('item_edit/{id}', 'ItemController@edit');
        Route::post('item_update/{id}', 'ItemController@update');
        Route::get('item_delete/{id}', 'ItemController@destroy');


        //Registered Users Routes
        Route::get('Rindex','RegUserController@index');
        Route::get('Redit/{id}', 'RegUserController@edit');
        Route::post('Rupdate/{id}', 'RegUserController@update');

        //Administrator Route
        Route::get('Aindex', 'AdministratorController@index');
        Route::get('Acreate', 'AdministratorController@create');
        Route::post('Asubmit', 'AdministratorController@store');
        Route::get('Aedit/{id}', 'AdministratorController@edit');
        Route::post('Aupdate/{id}', 'AdministratorController@update');
        Route::get('Adelete/{id}', 'AdministratorController@destroy');


        //Notification Route
        Route::get('notifications','NotificationController@index');
        Route::post('notifications/send','NotificationController@send');

        //slider route
        Route::get('slider_index','SliderController@index');
        Route::get('slider_create','SliderController@create');
        Route::post('slider_submit', 'SliderController@store');
        Route::get('slider_edit/{id}', 'SliderController@edit');
        Route::post('slider_update/{id}', 'SliderController@update');
        Route::get('slider_delete/{id}', 'SliderController@destroy');

		//Ads Route
        Route::get('advertisement','AdvertisementController@index');
        Route::post('advertisement/update','AdvertisementController@update');

        //Settings Route
        Route::get('settings','SettingsController@index');
        Route::post('settings/update','SettingsController@update');


    });
});
